/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.usb_cubby;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class Copy2ClipBoardClass
implements ActionListener {
    private final Clipboard systemClipboard;
    private StringSelection stringSelection;
    private JTable jTable;

    public Copy2ClipBoardClass(JTable jTable) {
        this.jTable = jTable;
        KeyStroke copy1 = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke copy2 = KeyStroke.getKeyStroke(155, 2, false);
        KeyStroke paste1 = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke paste2 = KeyStroke.getKeyStroke(155, 1, false);
        jTable.registerKeyboardAction(this, "Copy", copy1, 0);
        jTable.registerKeyboardAction(this, "Copy", copy2, 0);
        jTable.registerKeyboardAction(this, "Paste", paste1, 0);
        jTable.registerKeyboardAction(this, "Paste", paste2, 0);
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            usb_cubby.RestartTimer();
            usb_cubby.bClipBoardWasUsed = true;
            int row = this.jTable.getSelectedRow();
            int col = this.jTable.getSelectedColumn();
            if (event.getActionCommand().compareTo("Copy") == 0) {
                this.stringSelection = new StringSelection(this.jTable.getValueAt(row, col).toString());
                this.systemClipboard.setContents(this.stringSelection, null);
            }
            if (event.getActionCommand().compareTo("Paste") == 0) {
                String transferableString = (String)this.systemClipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                this.jTable.setValueAt(transferableString, row, col);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

